# Intro Email Examples

Each example shows an email written by a job seeker to their mutual connection (the forwarder), who can then forward it to someone at the target company.

## Example 1: Analytics PM → AnalyticsCo

**Scenario:**
- **Job Seeker**: Alex, PM with analytics background
- **Forwarder**: Mike (Alex's former colleague)
- **Target**: Someone Mike knows at AnalyticsCo
- **Context provided**: "Data-driven PM with 250% WAU growth at DesignCo, experience with complex permissions overhaul"

**Style**: DATA-DRIVEN (metrics emphasis)

**Email Alex sends to Mike:**

```
Subject: Quick intro request - AnalyticsCo Product Manager

Hey Mike,

Having achieved 250% WAU growth in our analytics product at DesignCo, I appreciate the scale of AnalyticsCo's platform challenges. My experience optimizing retention metrics showed me how critical accurate data is to product decisions, and I see direct parallels with how AnalyticsCo helps companies turn data into insights.

Quick background:
• Led analytics product growth from 10K to 35K WAU over 18 months
• Delivered complex permissions overhaul, enabling enterprise feature adoption
• Managed cross-functional team of 4 through high-growth period

Based on my experience scaling analytics products, I see valuable opportunities to help AnalyticsCo expand their enterprise offering.

Would you be open to connecting me with someone on the Product team? I'm interested in this role: https://analyticsCo.com/jobs/pm

Best,
Alex
```

**Mike can now forward this to his contact at AnalyticsCo with a quick "Hey, worth a look!"**

---

## Example 2: Engineering Manager → PaymentCo

**Scenario:**
- **Job Seeker**: Jordan, engineering manager
- **Forwarder**: Sarah (Jordan's friend from a conference)
- **Target**: Someone Sarah knows at PaymentCo
- **Context provided**: "Managed 8-person team through growth from 50 to 500 employees. Strong background in scalable systems and global team onboarding."

**Style**: ACTION-DRIVEN (building/scaling emphasis)

**Email Jordan sends to Sarah:**

```
Subject: Quick intro request - PaymentCo Engineering Manager

Hey Sarah,

Having managed engineering teams through company growth from 50 to 500 employees, I'm impressed by PaymentCo's infrastructure roadmap. Building scalable systems for rapidly growing orgs taught me that the difference between good and great teams is how well you onboard people and maintain quality at scale.

Quick background:
• Managed 8-person engineering team during 10x company growth over 3 years
• Built remote-first culture, onboarding 40+ engineers across 4 time zones
• Led infrastructure redesign achieving 99.95% uptime during rapid scaling

Based on my experience scaling engineering organizations globally, I see valuable opportunities to help PaymentCo strengthen distributed team operations.

Would you be open to connecting me with someone on the Engineering team? I'm interested in this role: https://paymentco.com/careers/eng-manager

Best,
Jordan
```

---

## Example 3: PM → Series A Startup

**Scenario:**
- **Job Seeker**: Taylor, PM at larger company wanting to go earlier stage
- **Forwarder**: Chris (Taylor's former manager)
- **Target**: Someone Chris knows at the startup
- **Context provided**: "Shipped 3 major product launches from conception to market. Experience taking products from 0-to-1."

**Style**: ACTION-DRIVEN (launching emphasis)

**Email Taylor sends to Chris:**

```
Subject: Quick intro request - Launchpad PM Role

Hey Chris,

After shipping 3 major product launches from conception to market, I'm energized by the problem Launchpad is solving in the SMB space. My experience taking products from 0-to-1 taught me that the best teams move fast, iterate on real feedback, and aren't afraid to kill things that aren't working.

Quick background:
• Shipped 3 major launches from strategy through go-live over 2 years
• Took feature from zero to 50K users in 6 months through rapid iteration
• Built GTM strategy for new category, resulting in $5M first-year revenue

Based on my experience launching products in new spaces, I see valuable opportunities to help Launchpad accelerate user growth.

Would you be open to connecting me with the product team or founders? I'm interested in this role: https://launchpad.io/jobs/pm

Best,
Taylor
```

---

## Example 4: Designer → Design Leadership

**Scenario:**
- **Job Seeker**: Morgan, product designer with design system experience
- **Forwarder**: Pat (Morgan's design community contact)
- **Target**: Someone Pat knows at the fintech company
- **Context provided**: "Led design system initiative used by 15+ teams. Passionate about accessible, user-centered design."

**Style**: Mixed DATA-DRIVEN + ACTION-DRIVEN

**Email Morgan sends to Pat:**

```
Subject: Quick intro request - FinanceApp Design Director

Hey Pat,

After leading a design system initiative now used by 15+ teams, I'm impressed by the thoughtfulness in FinanceApp's product experience. My work on design scalability taught me that great systems don't just save time—they raise the quality baseline and help new designers be productive immediately.

Quick background:
• Built design system from scratch, adopted across 15 teams and 100+ engineers
• Improved design-to-implementation handoff time by 35% through documentation
• Mentored 4 junior designers, 3 promoted to senior within 18 months

Based on my experience scaling design organizations, I see valuable opportunities to help FinanceApp build a best-in-class design culture.

Would you be open to connecting me with someone on the Design team? I'm interested in this role: https://financeapp.com/careers/design-director

Best,
Morgan
```

---

## How Context Changes the Email

Same job seeker, same target company, different context provided:

### Version A: Metrics-Focused Context
**Context**: "Led growth team that increased retention by 45% and achieved 3x revenue growth"

**Opening**: "Having led a growth team that increased retention by 45%, I appreciate the scale of AnalyticsCo's challenge in helping customers derive value from analytics..."

### Version B: Leadership-Focused Context
**Context**: "Managed distributed team across 3 continents, built collaborative culture despite timezone challenges"

**Opening**: "Having managed distributed teams across 3 continents, I'm impressed by AnalyticsCo's approach to supporting companies with global user bases..."

### Version C: Technical-Focused Context
**Context**: "Built analytics infrastructure handling 10B+ events per day"

**Opening**: "Having built analytics infrastructure handling 10B+ events per day, I understand the technical challenges behind reliable analytics platforms..."

**Key insight**: The same person emphasizes different strengths based on what they highlight in context, making each email targeted while remaining authentic.

---

## Edge Cases

### Minimal Context Provided
- Rely on resume for strongest achievements
- Ask for clarification if resume is thin
- Focus on clear role alignment

### Early Career / Thin Resume
- Emphasize specific projects and execution
- Use collaborative achievements
- Focus on learning velocity and scope of responsibility

### Career Pivot
- Bridge old background to new role
- Find transferable skills and concepts
- Acknowledge transition authentically

### No Job URL Available
- Reference job title and company instead
- Example closing: "Would you be open to connecting me with someone on the Product team? I'm interested in the Senior PM role."
