# Intro Email Reference Guide

## Analysis Framework

### Company Analysis (from job description)

Extract:
- **Stage**: Startup / Growth / Enterprise
- **Core problems**: What challenges are they solving?
- **Team structure**: Reporting lines, team size
- **Success metrics**: What does success look like for this role?
- **Target users**: Who benefits from the product?

### Candidate Analysis (from resume + context)

Identify:
- **Relevant achievements**: Top 3-5 with full context and metrics
- **Scale of impact**: Team size, user base, revenue
- **Company stages worked**: Startup, growth, enterprise experience
- **Transferable skills**: What translates to this role?

### Claim Verification

For each achievement mentioned in additional context:

| Status | Meaning | Usage |
|--------|---------|-------|
| VERIFIED | Found in resume with specific metrics | Use prominently |
| PARTIAL | Similar evidence but less specific | Use with context |
| UNSUPPORTED | Not found in resume | Do not use |

**Rule: Only use VERIFIED or PARTIAL claims. Never use UNSUPPORTED claims.**

### Style Selection

**DATA-DRIVEN** — Use when:
- Context emphasizes metrics, growth, analytics
- Job focuses on technical/analytical work
- Candidate has strong quantified achievements

Opening example: "Having achieved 250% WAU growth..."

**ACTION-DRIVEN** — Use when:
- Context emphasizes building, launching, leading
- Job focuses on product development, execution
- Candidate has 0-to-1 or founding experience

Opening example: "After launching our platform from 0-to-1..."

## Email Component Guidelines

### Subject Line
Format: `Quick intro request - [Company] [Role]`

### Opening (2-3 sentences)
1. First sentence: Connect strongest VERIFIED achievement to company's specific challenge
2. Second sentence: Show understanding of their situation
3. Use company/product names, never "you" or "your"

**Good**: "Having achieved 250% WAU growth in our analytics product, I appreciate the scale of AnalyticsCo's platform challenges."

**Bad**: "I saw your job posting and wanted to reach out." (generic, uses "your")

### Experience Bullets (exactly 3)
Each bullet needs:
- Action verb
- Specific metric from resume
- Context (team size, timeframe, scope)
- Max 12 words

Priority order:
1. HIGH PRIORITY achievement (most relevant to job)
2. MEDIUM PRIORITY achievement (supporting evidence)
3. Additional leadership or scale example

**Good**: "• Led analytics product growth from 10K to 35K WAU over 18 months"

**Bad**: "• Was responsible for growing the team" (passive, no metrics)

### Company Interest Statement
Formula: "Based on my experience [achievement], I see valuable opportunities to help [Company] [specific goal from job posting]."

### Closing
- Ask for intro to specific team (not "someone at the company")
- Include job URL
- Keep brief

Example: "Would you be open to connecting me with someone on the Product team? I'm interested in this role: [URL]"

## Formatting Rules

- Bullets: Use "• " (bullet + space), never dashes
- Company references: Always use company name, never "you/your"
- Length: Body under 150 words (excluding greeting/signature)
- Tone: Professional but conversational

## Common Pitfalls

| Mistake | Why It's Wrong | Fix |
|---------|----------------|-----|
| Addressing email to target contact | Forwarder can't just forward it | Address to the forwarder |
| Generic opening | Doesn't demonstrate knowledge | Connect achievement to company challenge |
| Using "you/your" | Awkward when forwarded | Use company/product names |
| Unverified claims | Damages credibility | Only use resume-backed achievements |
| Weak metrics | "Improved by 30%" means nothing without context | Include scale and timeframe |
| Too long | Gets skimmed or ignored | Stay under 150 words |
